package net.w_horse.excelpojo.xml.tag;

public enum RetrieveType {
	NONE("none"),
	LABELED_CELL("labeledCell"),
	POINTED_CELL("pointedCell"),
	CONSTANT_VALUE("constantValue"),
	VERTICAL_REPEATS("verticalRepeats"),
	HORIZONTAL_REPEATS("horizontalRepeats"),
	MAPPED_CELL("mappedCell");

	private String value;
	private RetrieveType(String value) {
		this.value = value;
	}
	public String getValue() {
		return this.value;
	}

	public static String getTagName() {
		return "retrieveType";
	}

	public static boolean equals(RetrieveType elementName, String expr) {
		RetrieveType retrieveTypeExpr = getElement(expr);
		return (retrieveTypeExpr == elementName);
	}

	public static boolean equalsIgnoreCase(RetrieveType elementName, String expr) {
		RetrieveType retrieveTypeExpr = getElementIgnoreCase(expr);
		return (retrieveTypeExpr == elementName);
	}

	public boolean equals(String expr) {
		return equals(this, expr);
	}
	public boolean equalsIgnoreCase(String expr) {
		return equalsIgnoreCase(this, expr);
	}

	private static RetrieveType getElement(String elementName) {
		if (elementName == null) {
			return NONE;
		}

		if (elementName.equals(LABELED_CELL.getValue())) {
			return LABELED_CELL;
		} else if (elementName.equals(POINTED_CELL.getValue())) {
			return POINTED_CELL;
		} else if (elementName.equals(CONSTANT_VALUE.getValue())) {
			return CONSTANT_VALUE;
		} else if (elementName.equals(VERTICAL_REPEATS.getValue())) {
			return VERTICAL_REPEATS;
		} else if (elementName.equals(HORIZONTAL_REPEATS.getValue())) {
			return HORIZONTAL_REPEATS;
		} else if (elementName.equals(MAPPED_CELL.getValue())) {
			return MAPPED_CELL;
		} else {
			return NONE;
		}
	}
	private static RetrieveType getElementIgnoreCase(String elementName) {
		if (elementName == null) {
			return NONE;
		}

		if (elementName.equalsIgnoreCase(LABELED_CELL.getValue())) {
			return LABELED_CELL;
		} else if (elementName.equalsIgnoreCase(POINTED_CELL.getValue())) {
			return POINTED_CELL;
		} else if (elementName.equalsIgnoreCase(CONSTANT_VALUE.getValue())) {
			return CONSTANT_VALUE;
		} else if (elementName.equalsIgnoreCase(VERTICAL_REPEATS.getValue())) {
			return VERTICAL_REPEATS;
		} else if (elementName.equalsIgnoreCase(HORIZONTAL_REPEATS.getValue())) {
			return HORIZONTAL_REPEATS;
		} else if (elementName.equalsIgnoreCase(MAPPED_CELL.getValue())) {
			return MAPPED_CELL;
		} else {
			return NONE;
		}
	}
}
